/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: VIC_Struct.h 4490 2020-08-13 13:32:21Z Robert $:

  Description:
    netX VIC definitions

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2010-03-24  File created.

**************************************************************************************/


#ifndef _VIC_STRUCT_H
#define _VIC_STRUCT_H


/*************************************************************************************/


/* structure map of netX VIC registers */

typedef struct NETX_VIC_BASE_Ttag
{
  volatile unsigned long ulIrqStatus;
  volatile unsigned long ulFiqStatus;
  volatile unsigned long ulRawIntr;
  volatile unsigned long ulIntSelect;
  volatile unsigned long ulIntEnable;
  volatile unsigned long ulIntEnclear;
  volatile unsigned long ulSoftint;
  volatile unsigned long ulSoftintClear;
  volatile unsigned long ulProtection;
  volatile unsigned long ulReserved[3];
  volatile unsigned long ulVectAddr;
  volatile unsigned long ulDefVectAddr;
  volatile unsigned long ulReservedB[50];
  volatile unsigned long aulVectAddr[16];
  volatile unsigned long ulReservedC[48];
  volatile unsigned long aulVectCntl[16];
} NETX_VIC_BASE_T;

#endif
